
#ifndef INTER_PROCESSOR_REQUEST_CONFIG_H
#define INTER_PROCESSOR_REQUEST_CONFIG_H

#include <linux/sched.h>
#include <scc/ucd_memmap.h>

//#define IPRQ_DEBUG
//#define IPRQ_MONITOR
#define IPRQ_WARNING
#define IPRQ_ASSERT
#define IPRQ_UNSUPPORTED

#ifdef CONFIG_MN2WS0220_ES1
#define IPRQ_MN2WS0220_ES1
#else /* CONFIG_MN2WS0220_ES1 */
#define IPRQ_L2_CACHEABLE
#endif /* CONFIG_MN2WS0220_ES1 */

#ifndef IPRQ_MN2WS0220_ES1
#define CONFIG_IPRQ_MEM_PADDR	(DDR_CH0_START + IOSC_START_OFFSET)
#define CONFIG_IPRQ_MEM_SIZE	IOSC_SIZE
#else /* IPRQ_MN2WS0220_ES1 */
#define IPRQ_USE_SWP
#define CONFIG_IPRQ_MEM_PADDR	(DDR_CH1_START + IOSC_START_OFFSET)
#define CONFIG_IPRQ_MEM_SIZE	IOSC_SIZE
#endif /* IPRQ_MN2WS0220_ES1 */

#define IPRQ_REQUEST_MAXNUM	256
#define IPRQ_REQUEST_BUFSIZE	16
#define IPRQ_POLLING_ENABLE

#define IPRQ_PRINT_BUFSIZE	256

enum {
	OS_L = 0,
	OS_R,
	OS_NUM
};

#define SELF_OSID()	OS_L

#define IPRQ_L_TO_R_IRQ	256
#define IPRQ_R_TO_L_IRQ	97	/* CPUINT3, ARMGIC233 */

#define IPRQ_L_TO_R_NMI	373

#define IPRQ_R_TO_L_GIC	233	/* CPUINT3, ARMGIC233 */

//#define PROC_REQUEST_GxICR_LV	6

#define CPUINT_FROM_OS_R	3

#define IPRQ_POLL_TIMEOUT	1000000		/* usec */
//#define IPRQ_TIMEOUT_SIGNAL	SIGUNUSED

#endif /* INTER_PROCESSOR_REQUEST_CONFIG_H */
